<?php 
function isSimilar($str1, $str2, $threshold = 0.8) {
    $distance = levenshtein(strtolower($str1), strtolower($str2));
    $maxLength = max(strlen($str1), strlen($str2));
    $similarity = 1 - $distance / $maxLength;
    return $similarity >= $threshold;
}
function jsonheader($origin = true){
    $head = '*';
    if($origin){
        $head = BASEURL;
    }
    header("Access-Control-Allow-Origin: $head");
    header("Content-Type: application/json; charset=UTF-8");
}
if(!function_exists('dcd')){
    function dcd(){
        echo '<xmp>';
        array_map(function($apa){
            var_dump($apa);
        }, func_get_args());
        echo '</xmp>';
        die();
    }
}

if(!function_exists('getallheaders')){
    function getallheaders(){
        $h = [];
        foreach ($_SERVER as $name => $value) {
            if (strncmp($name, 'HTTP_', 5) === 0) {
                $headerName = trim(str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5))))));
                $h[$headerName] = $value;
            } elseif (in_array($name, ['CONTENT_TYPE', 'CONTENT_LENGTH', 'CONTENT_MD5'])) {
                $headerName = trim(str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', $name)))));
                $h[$headerName] = $value;
            }
        }
        return $h;
    }
}
function formatRupiah($number) {
    if(empty($number))
        return 0;
    $formatted_number = number_format($number, 0, ',', '.');
    return $formatted_number;
}
function randomString($panjang = 6){
    $characters = '01234ABCDEFGHIJK56789LMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_,.';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $panjang; $i++) {
        $randomString .= $characters[random_int(0, $charactersLength - 1)];
    }

    return $randomString;
}
function tglIndo($tanggal, $format = 'd M Y') {
    $date = new DateTime($tanggal);

    // Raw formatted string (in English)
    $formatted = $date->format($format);

    // Maps for translation
    $hari = [
        'Sun' => 'Minggu',   'Mon' => 'Senin',   'Tue' => 'Selasa',
        'Wed' => 'Rabu',     'Thu' => 'Kamis',   'Fri' => 'Jumat',
        'Sat' => 'Sabtu',
        'Sunday' => 'Minggu', 'Monday' => 'Senin', 'Tuesday' => 'Selasa',
        'Wednesday' => 'Rabu', 'Thursday' => 'Kamis', 'Friday' => 'Jumat',
        'Saturday' => 'Sabtu'
    ];

    $bulan = [
        'January' => 'Januari',     'February' => 'Februari',
        'March' => 'Maret',         'April' => 'April',
        'May' => 'Mei',             'June' => 'Juni',
        'July' => 'Juli',           'August' => 'Agustus',
        'September' => 'September', 'October' => 'Oktober',
        'November' => 'November',   'December' => 'Desember',
        'Jan' => 'Jan', 'Feb' => 'Feb', 'Mar' => 'Mar', 'Apr' => 'Apr',
        'May' => 'Mei', 'Jun' => 'Jun', 'Jul' => 'Jul', 'Aug' => 'Agu',
        'Sep' => 'Sep', 'Oct' => 'Okt', 'Nov' => 'Nov', 'Dec' => 'Des'
    ];

    // Replace English day and month names with Indonesian ones
    $formatted = strtr($formatted, array_merge($hari, $bulan));

    return $formatted;
}

if(!function_exists('dc')){
    function dc(){
        echo '<xmp>';
        array_map(function($apa){
            var_dump($apa);
        }, func_get_args());
        echo '</xmp>';
    }
}
function cekInternet() {
    $connected = @fsockopen('www.google.com', 80, $errno, $errstr, 2);
    if ($connected) {
        fclose($connected);
        return true; 
    } else {
    // Jika koneksi gagal, kembalikan False
        return false;
    }
}